<?php
namespace App\Http\Controllers;
use App\Models\Questions;
use App\Models\Subscription;
use App\Models\User;
use App\Models\Institutions;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use DB;
class AdminController extends Controller
{
    public function getQuestionCount(Request $request)
    {
        $school_id = $request->school_id;
        return response()->json([
            'pending' => Questions::where('school_id', $school_id)->where('status', '0')->count(),
            'approved' => Questions::where('school_id', $school_id)->where('status', '1')->count(),
            'rejected' => Questions::where('school_id', $school_id)->where('status', '2')->count(),
        ]);
    }

    

    public function getUserCount(Request $request)
    {
        $query = User::query();
        if ($request->user()->role === 'admin') {
            $query->where('school_id', $request->user()->school_id);
        }
        return response()->json(['total_users' => $query->count()]);
    }

    public function getQuestionTrends(Request $request)
    {
        $query = Questions::where('status', 1)
            ->selectRaw('COUNT(*) as count, DATE_FORMAT(created_at, "%Y-%m") as month')
            ->groupBy('month')
            ->orderBy('month', 'asc')
            ->take(12);
        if ($request->user()->role === 'admin') {
            $query->where('school_id', $request->user()->school_id);
        }
        return response()->json(['trends' => $query->get()]);
    }

    // public function getPendingQuestions(Request $request)
    // {
    //     $query = Questions::with('metadata')->where('status', 0);
    //     if ($request->user()->role === 'admin') {
    //         $query->where('school_id', $request->school_id);
    //     }
    //     return response()->json(['questions' => $query->get()]);
    // }
    public function getPendingQuestions(Request $request)
{
    $query = Questions::with(['metadata', 'subject', 'subtopic', 'user'])->where('status', 0);

    if ($request->user()->role === 'admin') {
        $query->where('school_id', $request->school_id);
    }

    return response()->json([
        'questions' => $query->get()
    ]);
}


    public function approveQuestion(Request $request, $id)
    {
        $question = Questions::where('id', $request->id)->findOrFail($id);
        $statusMap = [
            'approved' => '1',
            'rejected' => '2',
        ];
        $question->status = $statusMap[$request->status] ?? $question->status;
        $question->save();
        return response()->json(['message' => 'Question updated']);
    }

    public function updateQuestion(Request $request, $id)
    {
        $question = Questions::where('school_id', $request->school_id)->findOrFail($id);
        $question->update([
            'question' => $request->question,
           'explanation' => $request->metadata,
            'answer' => $request->answer, // Accept JSON string or text
           
           
        ]);

        return response()->json(['message' => 'Question updated']);
    }

    public function getQuestions(Request $request)
    {
        $query = Questions::with('metadata');
        if ($request->subject_id) $query->where('subject_id', $request->subject_id);
        if ($request->difficulty) $query->where('difficulty', $request->difficulty);
        if ($request->status) $query->where('status', $request->status);
        if ($request->user()->role === 'admin') {
            $query->where('school_id', $request->user()->school_id);
        }
        return response()->json(['questions' => $query->get()]);
    }

    public function getUsers(Request $request)
    {
        if ($request->user()->role !== 'superadmin') {
            return response()->json(['error' => 'Unauthorized'], 403);
        }
        
        // Start with base query
        $query = User::with('school');
        
        // Apply search filter
        if ($request->has('search') && !empty($request->search)) {
            $search = $request->search;
            $query->where(function($q) use ($search) {
                $q->where('name', 'LIKE', "%{$search}%")
                  ->orWhere('email', 'LIKE', "%{$search}%");
            });
        }
        
        // Apply premium filter
        if ($request->has('is_premium') && $request->is_premium !== '') {
            $isPremium = filter_var($request->is_premium, FILTER_VALIDATE_BOOLEAN, FILTER_NULL_ON_FAILURE);
            if ($isPremium !== null) {
                $query->where('is_premium', $isPremium);
            }
        }
        
        // Get filtered users
        $users = $query->select('id', 'name', 'email', 'role', 'institution_id', 'is_premium')
                       ->orderBy('created_at', 'desc')
                       ->get();
        
        // Get all-time statistics (unfiltered)
        $allUsers = User::count();
        $premiumCount = User::where('is_premium', true)->count();
        $totalRevenue = Subscription::sum('amount');
        
        return response()->json([
            'users' => $users,
            'totalUsers' => $allUsers,
            'premiumUsers' => $premiumCount,
            'totalRevenue' => $totalRevenue,
            'filteredCount' => $users->count(), 
        ]);
    }

    public function updateUserRole($id, Request $request)
    {
        if ($request->user()->role !== 'superadmin') {
            return response()->json(['error' => 'Unauthorized'], 403);
        }
        $validator = Validator::make($request->all(), [
            'role' => 'required|in:superadmin,admin,user',
            'school_id' => 'required_if:role,admin|exists:schools,id|nullable',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()], 422);
        }
        $user = User::findOrFail($id);
        $user->role = $request->role;
        $user->school_id = $request->role === 'admin' ? $request->school_id : null;
        $user->save();
        return response()->json(['message' => 'User role updated']);
    }

    public function getSchools()
    {
        return response()->json(['schools' => Institutions::all(['id', 'name'])]);
    }
     // Toggle auto-generate setting
     public function toggleAutoGenerate(Request $request)
     {
        $id = $request->id;
         $subject = Subject::findOrFail($id);
 
         $validator = Validator::make($request->all(), [
             'auto_generate' => 'required|boolean'
         ]);
 
         if ($validator->fails()) {
             return response()->json([
                 'errors' => $validator->errors()
             ], 422);
         }
 
         $subject->update([
             'auto_generate' => $request->auto_generate
         ]);
 
         return response()->json([
             'message' => 'Auto-generate setting updated',
             'subject' => $subject
         ]);
     }
    public function contact(Request $request){
       
       $contact = DB::table('contact')->insert([
            'name' => $request->name,
            'email' => $request->email,
            'subject' => $request->subject,
            'message' => $request->message
        ]);
        if($contact){
            return response()->json(['message' => 'Message sent successfully']);
        }
    }
}