<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Subjects;
use App\Models\Subtopics;
use App\Models\Questions;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\ValidationException;
class SubtopicController extends Controller
{
    //
    // Update subtopic
    public function update(Request $request, $id)
    {
        $subtopic = Subtopics::findOrFail($id);

        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'description' => 'nullable|string'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'errors' => $validator->errors()
            ], 422);
        }

        $subtopic->update([
            'name' => $request->name,
            'description' => $request->description,
        ]);

        return response()->json([
            'message' => 'Subtopic updated successfully',
            'subtopic' => $subtopic
        ]);
    }

  
    public function destroy($id)
{
    $subtopic = Subtopics::findOrFail($id);
    Questions::where('subtopic_id', $id)->delete();
    
    $subtopic->delete();

    return response()->json([
        'message' => 'Subtopic deleted successfully'
    ]);
}
}
