<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Subjects;
use App\Models\Subtopics;
use App\Models\Institutions;

class Questions extends Model
{
    //
    protected $fillable = [
        'question',
        'answer',
        'subject_id',
        'subtopic_id',
        'difficulty',
        'question_type',
        'uploaded_by',
        'school_id',
        'updated_at',
        'explanation'
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];
    public function subject()
    {
        return $this->belongsTo(Subjects::class);
    }
    public function institution()
    {
        return $this->belongsTo(Institutions::class);
    }


    public function user()
    {
        return $this->belongsTo(User::class, 'uploaded_by');
    }

    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function metadata()
    {
        return $this->hasOne(QuestionMetadata::class, 'question_id', 'id');
    }
    public function subtopic()
    {
        return $this->belongsTo(Subtopics::class);
    }


}
