<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QuizSession extends Model
{
    use HasFactory;
    protected $table = 'quiz_sessions';
    protected $fillable = [
        'session_id',
        'user_id',
        'questions_data',
        'user_answers',
        'total_questions',
        'time_limit',
        'status',
        'score',
        'correct_answers',
        'started_at',
        'expires_at',
        'completed_at',
        'time_spent',
        'subject_id'
    ];

    protected $casts = [
        'questions_data' => 'array',
        'user_answers' => 'array',
        'score' => 'decimal:2',
        'started_at' => 'datetime',
        'expires_at' => 'datetime',
        'completed_at' => 'datetime'
    ];

    /**
     * Get the user that owns the quiz session
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Check if the quiz session is still active
     */
    public function isActive()
    {
        return $this->status === 'active' && $this->expires_at > now();
    }
    public function institution()
    {
        return $this->belongsTo(Institutions::class, 'institution_id');
    }

    /**
     * Check if the quiz session has expired
     */
    public function hasExpired()
    {
        return $this->expires_at < now();
    }

    /**
     * Mark session as expired
     */
    public function markAsExpired()
    {
        $this->update(['status' => 'expired']);
    }
    public function subject()
    {
        return $this->belongsTo(Subjects::class);
    }
}