import React, { useState } from 'react';
import { Link } from 'react-router-dom';
import { Stethoscope } from 'lucide-react';

function Header() {
  const [isOpen, setIsOpen] = useState(false);

  const toggleMenu = () => {
    setIsOpen(!isOpen);
  };

  return (
    <header className="bg-white shadow-md fixed w-full top-0 z-50">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4 flex justify-between items-center">
        {/* Logo */}
        <div className="flex items-center">
          <Link to="/" className="flex items-center space-x-2">
            <Stethoscope className="w-8 h-8 text-[#38bdf8]" />
            <h1 className="text-2xl sm:text-3xl font-extrabold text-[#1e3a8a]">MedArchieve</h1>
          </Link>
        </div>

        {/* Desktop Menu */}
        <div className="hidden md:flex items-center justify-center grow">
          <nav className="flex space-x-8">
            <Link
              to="/"
              className="text-[#1e3a8a] text-lg font-medium hover:text-[#38bdf8] transition-colors duration-300"
            >
              Home
            </Link>
            <Link
              to="/about"
              className="text-[#1e3a8a] text-lg font-medium hover:text-[#38bdf8] transition-colors duration-300"
            >
              About
            </Link>
            <Link
              to="/services"
              className="text-[#1e3a8a] text-lg font-medium hover:text-[#38bdf8] transition-colors duration-300"
            >
              Services
            </Link>
            <Link
              to="/contact"
              className="text-[#1e3a8a] text-lg font-medium hover:text-[#38bdf8] transition-colors duration-300"
            >
              Contact
            </Link>
          </nav>
        </div>

        {/* Get Started Button (Desktop) */}
        <div className="hidden md:flex items-center">
          <Link
            to="/register"
            className="bg-gradient-to-r from-blue-700 to-cyan-700 text-white px-6 py-2 rounded-full hover:bg-[#0284c7] transition-colors duration-300 font-semibold text-lg"
            aria-label="Get started with MedArchieve"
          >
            Get Started
          </Link>
        </div>

        {/* Hamburger Button for Mobile */}
        <button
          className="md:hidden text-[#1e3a8a] focus:outline-none focus:ring-2 focus:ring-[#38bdf8] rounded-md p-2"
          onClick={toggleMenu}
          aria-label="Toggle navigation menu"
          aria-expanded={isOpen}
        >
          <svg
            className="w-6 h-6"
            fill="none"
            stroke="currentColor"
            viewBox="0 0 24 24"
            xmlns="http://www.w3.org/2000/svg"
          >
            <path
              strokeLinecap="round"
              strokeLinejoin="round"
              strokeWidth="2"
              d={isOpen ? 'M6 18L18 6M6 6l12 12' : 'M4 6h16M4 12h16m-7 6h7'}
            />
          </svg>
        </button>
      </div>

      {/* Mobile Menu */}
      <div
        className={`md:hidden bg-gradient-to-b from-[#e0f2fe] to-[#bfdbfe] overflow-hidden transition-all duration-500 ease-in-out ${
          isOpen ? 'max-h-96 opacity-100' : 'max-h-0 opacity-0'
        }`}
      >
        <nav className="flex flex-col items-center py-6 space-y-4">
          <Link
            to="/"
            className="text-[#1e3a8a] text-lg font-medium hover:text-[#38bdf8] transition-colors duration-300"
            onClick={toggleMenu}
          >
            Home
          </Link>
          <Link
            to="/about"
            className="text-[#1e3a8a] text-lg font-medium hover:text-[#38bdf8] transition-colors duration-300"
            onClick={toggleMenu}
          >
            About
          </Link>
          <Link
            to="/services"
            className="text-[#1e3a8a] text-lg font-medium hover:text-[#38bdf8] transition-colors duration-300"
            onClick={toggleMenu}
          >
            Services
          </Link>
          <Link
            to="/contact"
            className="text-[#1e3a8a] text-lg font-medium hover:text-[#38bdf8] transition-colors duration-300"
            onClick={toggleMenu}
          >
            Contact
          </Link>
          <Link
            to="/get-started"
            className="bg-[#38bdf8] text-white px-6 py-2 rounded-full hover:bg-[#0284c7] transition-colors duration-300 font-semibold text-lg"
            onClick={toggleMenu}
            aria-label="Get started with MedArchieve"
          >
            Get Started
          </Link>
        </nav>
      </div>
    </header>
  );
}

export default Header;
