import React, { useState } from 'react';

function Pricing() {
  const [hoveredCard, setHoveredCard] = useState(null);

  return (
    <section className="bg-gradient-to-br from-purple-50 via-blue-50 via-cyan-50 to-indigo-100 py-24 relative overflow-hidden">
      {/* Floating Geometric Shapes */}
      <div className="absolute inset-0 overflow-hidden pointer-events-none">
        <div className="absolute top-20 left-10 w-32 h-32 bg-gradient-to-r from-blue-500/10 to-cyan-500/10 rounded-full blur-xl animate-pulse"></div>
        <div className="absolute top-40 right-20 w-24 h-24 bg-gradient-to-r from-purple-500/10 to-pink-500/10 rounded-2xl rotate-45 blur-lg animate-pulse" style={{ animationDelay: '1s' }}></div>
        <div className="absolute bottom-32 left-20 w-20 h-20 bg-gradient-to-r from-rose-500/10 to-pink-500/10 rounded-full blur-lg animate-pulse" style={{ animationDelay: '2s' }}></div>
        <div className="absolute bottom-20 right-10 w-28 h-28 bg-gradient-to-r from-orange-500/10 to-red-500/10 rounded-3xl rotate-12 blur-xl animate-pulse" style={{ animationDelay: '0.5s' }}></div>
      </div>

      <div className="max-w-6xl mx-auto px-4 relative z-10">
        {/* Header */}
        <div className="text-center mb-20">
          <div className="inline-block mb-4">
            <span className="bg-gradient-to-r from-blue-600 to-cyan-600 bg-clip-text text-transparent text-sm font-semibold tracking-wide uppercase">
              Pricing Plans
            </span>
          </div>
          <h2 className="text-5xl md:text-6xl font-bold text-gray-900 mb-6 tracking-tight">
            Start Your
            <span className="block bg-gradient-to-r from-blue-600 to-cyan-600 bg-clip-text text-transparent">
              Free Trial Today
            </span>
          </h2>
          <p className="text-xl text-gray-600 max-w-2xl mx-auto leading-relaxed">
            Get full access to all premium features for 3 days, completely free. No credit card required.
          </p>
        </div>

        {/* Pricing Cards */}
        <div className="grid grid-cols-1 lg:grid-cols-2 gap-8 max-w-5xl mx-auto">
          
          {/* Free Trial Card */}
          <div 
            className={`relative group cursor-pointer transition-all duration-500 ${
              hoveredCard === 'trial' ? 'scale-105 shadow-2xl' : 'hover:scale-105 hover:shadow-2xl'
            }`}
            onMouseEnter={() => setHoveredCard('trial')}
            onMouseLeave={() => setHoveredCard(null)}
          >
            {/* Card Shadow Effect */}
            <div className="absolute inset-0 bg-gradient-to-r from-blue-500/20 to-purple-500/20 rounded-3xl blur-xl opacity-0 group-hover:opacity-100 transition-all duration-500"></div>
            
            <div className="relative bg-white border-2 border-blue-200 p-8 rounded-3xl shadow-lg hover:shadow-xl transition-all duration-500">
              {/* Decorative Corner */}
              <div className="absolute top-0 right-0 w-20 h-20 bg-gradient-to-br from-blue-500/10 to-purple-500/10 rounded-bl-3xl rounded-tr-3xl"></div>
              
              {/* Badge */}
              <div className="inline-flex items-center px-4 py-2 bg-gradient-to-r from-blue-500 to-purple-500 rounded-full text-white text-sm font-semibold mb-6 shadow-lg animate-pulse">
                <span className="w-2 h-2 bg-white rounded-full mr-2"></span>
                🎉 Start Here
              </div>
              
              <div className="mb-8">
                <h3 className="text-3xl font-bold text-gray-900 mb-2">3-Day Free Trial</h3>
                <div className="flex items-baseline mb-4">
                  <span className="text-6xl font-bold text-blue-600">FREE</span>
                  <span className="text-xl text-gray-500 ml-2">for 3 days</span>
                </div>
                <p className="text-gray-600 font-medium">Full access to all premium features</p>
                <p className="text-sm text-blue-600 mt-2">⚡ No credit card required</p>
              </div>

              <ul className="space-y-4 mb-8">
                {[
                  { text: 'Unlimited practice questions', icon: '✓' },
                  { text: 'Comprehensive study guides', icon: '✓' },
                  { text: 'Advanced progress tracking', icon: '✓' },
                  { text: 'Personalized AI tutoring', icon: '✓' },
                  { text: 'Priority support', icon: '✓' },
                  { text: 'Offline access', icon: '✓' }
                ].map((feature, index) => (
                  <li key={index} className="flex items-center text-gray-700">
                    <div className="w-8 h-8 bg-gradient-to-r from-blue-500 to-purple-500 rounded-full flex items-center justify-center mr-4 flex-shrink-0">
                      <span className="text-white text-sm font-bold">{feature.icon}</span>
                    </div>
                    <span className="text-lg">{feature.text}</span>
                  </li>
                ))}
              </ul>

              <button className="w-full bg-gradient-to-r from-blue-500 to-purple-500 text-white font-semibold py-4 px-6 rounded-2xl hover:from-blue-600 hover:to-purple-600 transform hover:scale-105 transition-all duration-300 shadow-lg hover:shadow-xl">
                Start Free Trial
              </button>
              
              <p className="text-xs text-gray-500 text-center mt-3">
                Cancel anytime during trial • No charges until trial ends
              </p>
            </div>
          </div>

          {/* Monthly Plan Card */}
          <div 
            className={`relative group cursor-pointer transition-all duration-500 ${
              hoveredCard === 'monthly' ? 'scale-105 shadow-2xl' : 'hover:scale-105 hover:shadow-2xl'
            }`}
            onMouseEnter={() => setHoveredCard('monthly')}
            onMouseLeave={() => setHoveredCard(null)}
          >
            {/* Card Shadow Effect */}
            <div className="absolute inset-0 bg-gradient-to-r from-purple-500/20 to-pink-500/20 rounded-3xl blur-xl opacity-0 group-hover:opacity-100 transition-all duration-500"></div>
            
            <div className="relative bg-gradient-to-br from-gray-50 to-white border-2 border-gray-200 p-8 rounded-3xl shadow-xl">
              {/* Decorative Corner */}
              <div className="absolute top-0 right-0 w-20 h-20 bg-gradient-to-br from-purple-500/10 to-pink-500/10 rounded-bl-3xl rounded-tr-3xl"></div>
              
              {/* Badge */}
              <div className="inline-flex items-center px-4 py-2 bg-gradient-to-r from-purple-50 to-pink-50 border border-purple-200 rounded-full text-purple-700 text-sm font-semibold mb-6">
                <span className="w-2 h-2 bg-purple-500 rounded-full mr-2"></span>
                After Trial
              </div>
              
              <div className="mb-8">
                <h3 className="text-3xl font-bold text-gray-900 mb-2">Monthly Plan</h3>
                <div className="flex items-baseline mb-4">
                  <span className="text-6xl font-bold text-gray-900">$29</span>
                  <span className="text-xl text-gray-500 ml-2">/month</span>
                </div>
                <p className="text-gray-600">Continue with full access after your trial</p>
                <p className="text-sm text-purple-600 mt-2 font-medium">Automatically starts after 3-day trial</p>
              </div>

              <ul className="space-y-4 mb-8">
                {[
                  { text: 'Everything from the trial', icon: '✓' },
                  { text: 'Unlimited practice questions', icon: '✓' },
                  { text: 'Comprehensive study guides', icon: '✓' },
                  { text: 'Advanced progress tracking', icon: '✓' },
                  { text: 'Personalized AI tutoring', icon: '✓' },
                  { text: 'Priority support & offline access', icon: '✓' }
                ].map((feature, index) => (
                  <li key={index} className="flex items-center text-gray-700">
                    <div className="w-8 h-8 bg-gradient-to-r from-purple-500 to-pink-500 rounded-full flex items-center justify-center mr-4 flex-shrink-0">
                      <span className="text-white text-sm font-bold">{feature.icon}</span>
                    </div>
                    <span className="text-lg">{feature.text}</span>
                  </li>
                ))}
              </ul>

              <div className="border-2 border-dashed border-gray-300 rounded-2xl p-4 text-center">
                <p className="text-gray-600 font-medium">Ready to continue after trial?</p>
                <p className="text-sm text-gray-500 mt-1">You'll be notified before any charges</p>
              </div>
            </div>
          </div>
        </div>

        {/* How it works section */}
        <div className="mt-20 text-center">
          <div className="inline-block bg-gradient-to-r from-gray-50 to-white border border-gray-200 rounded-2xl p-8 shadow-lg max-w-4xl">
            <h3 className="text-2xl font-bold text-gray-900 mb-6">How it works</h3>
            <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
              <div className="text-center">
                <div className="w-12 h-12 bg-gradient-to-r from-blue-500 to-purple-500 rounded-full flex items-center justify-center mx-auto mb-3">
                  <span className="text-white font-bold text-lg">1</span>
                </div>
                <h4 className="font-semibold text-gray-900 mb-2">Start Free Trial</h4>
                <p className="text-sm text-gray-600">Get 3 days of full access to all premium features, no credit card needed</p>
              </div>
              <div className="text-center">
                <div className="w-12 h-12 bg-gradient-to-r from-blue-500 to-cyan-500 rounded-full flex items-center justify-center mx-auto mb-3">
                  <span className="text-white font-bold text-lg">2</span>
                </div>
                <h4 className="font-semibold text-gray-900 mb-2">Explore Everything</h4>
                <p className="text-sm text-gray-600">Use all features including AI tutoring, unlimited questions, and progress tracking</p>
              </div>
              <div className="text-center">
                <div className="w-12 h-12 bg-gradient-to-r from-purple-500 to-pink-500 rounded-full flex items-center justify-center mx-auto mb-3">
                  <span className="text-white font-bold text-lg">3</span>
                </div>
                <h4 className="font-semibold text-gray-900 mb-2">Continue or Cancel</h4>
                <p className="text-sm text-gray-600">After 3 days, continue with monthly plan or cancel anytime with no charges</p>
              </div>
            </div>
          </div>
        </div>
      </div>

      {/* Floating Elements */}
      <div className="absolute inset-0 overflow-hidden pointer-events-none">
        {[...Array(12)].map((_, i) => (
          <div
            key={i}
            className="absolute w-1 h-1 bg-gradient-to-r from-blue-400 to-cyan-400 rounded-full animate-pulse"
            style={{
              left: `${Math.random() * 100}%`,
              top: `${Math.random() * 100}%`,
              animationDelay: `${Math.random() * 3}s`,
              animationDuration: `${3 + Math.random() * 2}s`
            }}
          ></div>
        ))}
      </div>
    </section>
  );
}

export default Pricing;