import React from 'react';
import { Crown, Zap, Lock, Brain, ArrowRight, CheckCircle } from 'lucide-react';
import { useNavigate } from 'react-router-dom';

const PremiumBanner = () => {
  const navigate = useNavigate();

  const features = [
    {
      icon: Zap,
      title: 'Unlimited AI Generations',
      description: 'Create unlimited practice questions tailored to your learning needs',
      color: 'indigo'
    },
    {
      icon: Crown,
      title: 'Priority Support',
      description: 'Receive expedited assistance from our dedicated support team',
      color: 'amber'
    },
    {
      icon: Brain,
      title: 'Advanced Study Tools',
      description: 'Access in-depth analytics, custom decks, and comprehensive insights',
      color: 'emerald'
    }
  ];

  const getColorClasses = (color) => {
    const colors = {
      indigo: 'bg-indigo-100 text-indigo-700',
      amber: 'bg-amber-100 text-amber-700',
      emerald: 'bg-emerald-100 text-emerald-700'
    };
    return colors[color];
  };

  return (
    <div className="relative bg-gradient-to-br from-white to-gray-50 border border-gray-200 rounded-2xl shadow-xl overflow-hidden my-10">
      {/* Premium accent border */}
      <div className="h-1.5 bg-gradient-to-r from-indigo-600 via-purple-600 to-indigo-600"></div>

      <div className="px-6 sm:px-8 lg:px-12 py-12 lg:py-16">
        {/* Header Section */}
        <div className="text-center mb-12">
          <div className="inline-flex items-center justify-center w-20 h-20 bg-gradient-to-br from-indigo-100 to-indigo-50 rounded-2xl mb-6 shadow-sm">
            <Lock className="w-10 h-10 text-indigo-600" />
          </div>

          <h2 className="text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900 mb-4 tracking-tight">
            Upgrade to Premium
          </h2>

          <p className="text-lg sm:text-xl text-gray-600 max-w-3xl mx-auto leading-relaxed">
            Unlock powerful tools designed to accelerate your medical learning with unlimited AI-generated questions, 
            advanced performance analytics, and exclusive premium content.
          </p>
        </div>

        {/* Feature Grid */}
        <div className="grid grid-cols-1 md:grid-cols-3 gap-6 lg:gap-8 max-w-5xl mx-auto mb-12">
          {features.map((feature, index) => {
            const Icon = feature.icon;
            return (
              <div 
                key={index}
                className="flex flex-col items-center text-center p-6 rounded-xl bg-white border border-gray-100 hover:border-indigo-200 hover:shadow-md transition-all duration-300"
              >
                <div className={`w-14 h-14 ${getColorClasses(feature.color)} rounded-xl flex items-center justify-center mb-4 shadow-sm`}>
                  <Icon className="w-7 h-7" />
                </div>
                <h3 className="font-semibold text-gray-900 text-lg mb-2">
                  {feature.title}
                </h3>
                <p className="text-sm text-gray-600 leading-relaxed">
                  {feature.description}
                </p>
              </div>
            );
          })}
        </div>

        {/* Additional Benefits */}
        <div className="max-w-2xl mx-auto mb-12">
          <div className="grid grid-cols-1 sm:grid-cols-2 gap-3">
            {[
              'Ad-free studying experience',
              'Exclusive premium content',
              'Advanced performance tracking',
              'Custom study schedules'
            ].map((benefit, index) => (
              <div key={index} className="flex items-center gap-2 text-gray-700">
                <CheckCircle className="w-5 h-5 text-emerald-600 flex-shrink-0" />
                <span className="text-sm font-medium">{benefit}</span>
              </div>
            ))}
          </div>
        </div>

        {/* CTA Section */}
        <div className="text-center">
          <button
            onClick={() => navigate('/dashboard/premium')}
            className="inline-flex items-center gap-3 bg-gradient-to-r from-indigo-600 to-indigo-700 hover:from-indigo-700 hover:to-indigo-800 text-white font-semibold text-lg px-10 py-4 rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-0.5"
          >
            View Premium Plans
            <ArrowRight className="w-5 h-5" />
          </button>

          <p className="text-sm text-gray-500 mt-6">
            Join thousands of medical students achieving exceptional results with Premium
          </p>
        </div>
      </div>

      {/* Decorative background element */}
      <div className="absolute top-0 right-0 -z-10 w-64 h-64 bg-indigo-50 rounded-full blur-3xl opacity-30 pointer-events-none"></div>
      <div className="absolute bottom-0 left-0 -z-10 w-64 h-64 bg-purple-50 rounded-full blur-3xl opacity-30 pointer-events-none"></div>
    </div>
  );
};

export default PremiumBanner;