import { usePremium } from '../../context/premiumContext';
import PremiumBanner from './PremiumBanner';

const RequirePremium = ({ children, fallback = null }) => {
  const { isPremium, isInTrial, trialDaysLeft, loadingPremium } = usePremium();

  if (loadingPremium) {
    return <div className="py-20 text-center">Loading access...</div>;
  }

  const hasAccess = isPremium || isInTrial;

  if (!hasAccess) {
    return (
      <>
        <PremiumBanner />
        {fallback || <p className="text-center mt-8 text-gray-600">This feature requires a Premium subscription.</p>}
      </>
    );
  }

  // If in trial, show subtle banner
  if (isInTrial && trialDaysLeft <= 2) {
    return (
      <div>
        <div className="bg-amber-50 border border-amber-200 rounded-xl p-4 mb-6 text-center">
          <p className="text-amber-900 font-medium">
            {trialDaysLeft === 0 
              ? "Your free trial ends today!" 
              : `Your free trial ends in ${trialDaysLeft} day${trialDaysLeft === 1 ? '' : 's'}`}
          </p>
          <button
            onClick={() => window.location.href = '/dashboard/premium'}
            className="mt-2 text-amber-700 underline hover:text-amber-800"
          >
            Upgrade now to keep full access
          </button>
        </div>
        {children}
      </div>
    );
  }

  return children;
};

export default RequirePremium;