import { usePremium } from '../../context/premiumContext';
import React, { useState, useEffect, createContext, useContext } from 'react';
import { X } from 'lucide-react';
const TrialMarquee = () => {
    const { isInTrial, trialEndDate } = usePremium();
    const [dismissed, setDismissed] = useState(false);
  
    if (!isInTrial || !trialEndDate || dismissed) return null;
  
    return (
      <div className="relative bg-gradient-to-r from-indigo-600 to-purple-600 text-white">
        <div className="py-3 overflow-hidden">
          <div className="animate-marquee whitespace-nowrap inline-block">
            <span className="mx-8 text-lg font-medium">
              🎉 Congratulations! Your 4-day Premium free trial has started!
              Full access until <strong>{trialEndDate}</strong>
            </span>
            <span className="mx-8 text-lg font-medium">
              🎉 Congratulations! Your 4-day Premium free trial has started!
              Full access until <strong>{trialEndDate}</strong>
            </span>
          </div>
        </div>
  
        {/* Close button */}
        <button
          onClick={() => setDismissed(true)}
          className="absolute top-2 right-4 text-white/80 hover:text-white"
        >
          <X size={20} />
        </button>
  
        <style jsx>{`
          @keyframes marquee {
            0% { transform: translateX(0%); }
            100% { transform: translateX(-50%); }
          }
          .animate-marquee {
            animation: marquee 25s linear infinite;
          }
        `}</style>
      </div>
    );
  };
export default TrialMarquee;