import React from 'react';

const DeckCard = ({ name, count, icon, color, onStart }) => {
  const colorClasses = {
    indigo: 'bg-indigo-50 text-indigo-700 hover:bg-indigo-100',
    blue: 'bg-blue-50 text-blue-700 hover:bg-blue-100',
    red: 'bg-red-50 text-red-700 hover:bg-red-100',
    purple: 'bg-purple-50 text-purple-700 hover:bg-purple-100',
    green: 'bg-green-50 text-green-700 hover:bg-green-100',
    orange: 'bg-orange-50 text-orange-700 hover:bg-orange-100',
    pink: 'bg-pink-50 text-pink-700 hover:bg-pink-100',
  };

  const bgClass = colorClasses[color] || colorClasses.indigo;

  return (
    <button
      onClick={onStart}
      className="p-6 bg-white rounded-xl shadow-sm border border-gray-200 hover:shadow-md hover:border-gray-300 transition-all text-left group"
    >
      <div className={`w-12 h-12 rounded-lg ${bgClass} flex items-center justify-center mb-4 group-hover:scale-110 transition-transform`}>
        {icon}
      </div>
      <h3 className="font-semibold text-gray-900">{name}</h3>
      <p className="text-2xl font-bold text-gray-900 mt-2">{count}</p>
      <p className="text-sm text-gray-500 mb-4">cards</p>
      <span className="inline-flex items-center text-indigo-600 font-medium text-sm group-hover:text-indigo-700">
        Start Studying →
      </span>
    </button>
  );
};

export default DeckCard; 