import React from 'react'
import Header from '../components/Header'
import Banner from '../assets/banner.jpg'
import { Users, Target, Award, BookOpen, Brain, Globe, Heart, Zap, Eye, ArrowRight, CheckCircle } from 'lucide-react'
import Footer from '../components/Footer'
import image from '../assets/image2.jpg'
import Features from '../components/Features'
function Service() {
  
  return (
    <div className='bg-white'>
        <Header />
      
     
      <section className="relative h-[30rem] lg:h-[28rem] overflow-hidden">
        <div className="absolute inset-0">
          <img 
            src={Banner} 
            alt="Medical Education Banner"
            className="w-full h-full object-cover scale-105 transition-transform duration-700 hover:scale-110" 
          />
          <div className="absolute inset-0 bg-gradient-to-br from-slate-900/85 via-blue-900/80 to-indigo-900/85"></div>
        </div>
        
        <div className="absolute inset-0 flex items-center justify-center">
          <div className="text-center text-white max-w-5xl px-4 pt-20">
            <div className="mb-6">
              <span className="inline-block px-4 py-2 bg-white/10 backdrop-blur-sm rounded-full text-sm font-medium border border-white/20">
                Home → Services
              </span>
            </div>
            <h1 className="text-5xl md:text-7xl font-extrabold mb-8 tracking-tight bg-gradient-to-r from-white via-blue-100 to-cyan-100 bg-clip-text text-transparent">
              Our Services
            </h1>
            <p className="text-xl md:text-2xl mb-8 leading-relaxed text-blue-100 max-w-3xl mx-auto">
              Empowering the next generation of medical professionals through innovative technology driven education
            </p>
            <div className="flex justify-center">
              <div className="w-24 h-1 bg-gradient-to-r from-cyan-400 to-blue-500 rounded-full"></div>
            </div>
          </div>
        </div>

        {/* Enhanced Floating Elements */}
        <div className="absolute inset-0 overflow-hidden pointer-events-none">
          {[...Array(12)].map((_, i) => (
            <div
              key={i}
              className="absolute animate-float"
              style={{
                left: `${Math.random() * 100}%`,
                top: `${Math.random() * 100}%`,
                animationDelay: `${Math.random() * 5}s`,
                animationDuration: `${4 + Math.random() * 3}s`
              }}
            >
              <div className="w-2 h-2 bg-cyan-400/30 rounded-full blur-sm"></div>
            </div>
          ))}
        </div>
      </section>
      <Features />
      <Footer />
    </div>
  )
}

export default Service