<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\QuestionGeneratorController;
use App\Http\Controllers\MedicalQuestionGeneratorController;
use App\Http\Controllers\CourseController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\SubjectController;
use App\Http\Controllers\SubtopicController;
use App\Http\Controllers\FlashcardController;
Route::get('/user', function (Request $request) {
    return Auth::id();
})->middleware('auth:sanctum');
Route::post('/register', [AuthController::class, 'register']);
Route::post('/login', [AuthController::class, 'login']);
Route::get('/institutions', [AuthController::class, 'institutions']);
Route::get('/dashboard/subjects', [DashboardController::class, 'index']);
Route::get('/dashboard/subjects/{subjectId}/subtopics', [DashboardController::class, 'subtopic']);
// Route::get('/dashboard/subjects/{id}/toggle-auto-generate', [AdminController::class, 'toggleAutoGenerate']);
Route::post('/dashboard/subjects', [SubjectController::class, 'store']);
Route::put('/dashboard/subjects/{id}', [SubjectController::class, 'update']);
Route::delete('/dashboard/subjects/{id}', [SubjectController::class, 'destroy']);
Route::put('/dashboard/subjects/{id}/toggle-auto-generate', [SubjectController::class, 'toggleAutoGenerate']);
Route::post('/dashboard/subjects/{subjectId}/subtopics', [SubjectController::class, 'storeSubtopic']);
    Route::put('/dashboard/subtopics/{id}', [SubtopicController::class, 'update']);
    Route::delete('/dashboard/subtopics/{id}', [SubtopicController::class, 'destroy']);

Route::post('/dashboard/questions', [DashboardController::class, 'question_store']);
Route::get('/dashboard/get-questions', [DashboardController::class, 'getQuestions']);
Route::post('/dashboard/quiz/save-result', [DashboardController::class, 'quiz_result']);
Route::get('/dashboard/get-essay', [DashboardController::class, 'essay']);
Route::get('/dashboard/viva-types', [DashboardController::class, 'getVivaTypes']);
Route::middleware(['auth:sanctum'])->prefix('admin')->group(function () {
    Route::get('questions/count', [AdminController::class, 'getQuestionCount']);
    Route::get('users/count', [AdminController::class, 'getUserCount']);
    Route::get('questions/trends', [AdminController::class, 'getQuestionTrends']);
    Route::get('questions/pending', [AdminController::class, 'getPendingQuestions']);
    Route::post('questions/{id}/approve', [AdminController::class, 'approveQuestion']);
    Route::post('questions/{id}/update', [AdminController::class, 'updateQuestion']);

    Route::get('questions', [AdminController::class, 'getQuestions']);
    Route::get('users', [AdminController::class, 'getUsers']);
    Route::post('users/{id}/role', [AdminController::class, 'updateUserRole']);
    Route::get('schools', [AdminController::class, 'getSchools']);
});
Route::middleware(['auth:sanctum'])->prefix('superadmin')->group(function () {
   
});
Route::post('/contact', [AdminController::class, 'contact']);
Route::get('/questions/auto-generate', [MedicalQuestionGeneratorController::class, 'autoGenerate']);
Route::middleware('auth:sanctum')->group(function () {
   
    Route::get('/dashboard/profile', [DashboardController::class, 'profile']);
    Route::get('/dashboard/user-stats', [DashboardController::class, 'userStats']);
    Route::post('/quiz/start', [DashboardController::class, 'startQuiz']);
    Route::post('/quiz/submit', [DashboardController::class, 'submitQuiz']);
    Route::post('/quiz/check-answer', [DashboardController::class, 'checkAnswer']);
    Route::post('/ai-generate-questions', [QuestionGeneratorController::class, 'ai_generateQuestions']);
    Route::get('/user-questions', [QuestionGeneratorController::class, 'user_questions']);
    Route::post('/courses', [CourseController::class, 'add_course']);
    Route::get('/courses', [CourseController::class, 'get_course']);
    Route::get('/public-quiz', [CourseController::class, 'get_public_quiz']);
    Route::get('/delete-course/{id}', [CourseController::class, 'delete_course']);
    Route::put('/edit-course/{id}', [CourseController::class, 'edit_course']);
    Route::get('/personal_questions', [CourseController::class, 'get_personal_questions']);
    Route::post('/verify-payment', [PaymentController::class, 'verifyPayment']);
    Route::get('/subscription-status', [PaymentController::class, 'getSubscriptionStatus']);
    Route::post('/user/{id}/toggle-premium', [PaymentController::class, 'admin_premium']);
    Route::delete('/users/{id}/remove-premium', [PaymentController::class, 'remove_premium']);
    Route::post('/logout', [DashboardController::class, 'logout']);
    Route::get('users', [AdminController::class, 'getUsers']);

     // Flashcard endpoints
     Route::get('/flashcards/stats', [FlashcardController::class, 'getStats']);
     Route::get('/flashcards/due', [FlashcardController::class, 'getDueCards']);
     Route::get('/flashcards/all', [FlashcardController::class, 'getAllCards']);
     Route::get('/flashcards/mistakes', [FlashcardController::class, 'getMistakes']);
     Route::get('/flashcards/course/{courseId}', [FlashcardController::class, 'getCardsByCourse']);
     Route::post('/flashcards/{questionId}/review', [FlashcardController::class, 'submitReview']);
});
