<?php
/**
 * This file is part of PHPPresentation - A pure PHP library for reading and writing
 * presentations documents.
 *
 * PHPPresentation is free software distributed under the terms of the GNU Lesser
 * General Public License version 3 as published by the Free Software Foundation.
 *
 * For the full copyright and license information, please read the LICENSE
 * file that was distributed with this source code. For the full list of
 * contributors, visit https://github.com/PHPOffice/PHPPresentation/contributors.
 *
 * @copyright   2009-2015 PHPPresentation contributors
 * @license     http://www.gnu.org/licenses/lgpl.txt LGPL version 3
 * @link        https://github.com/PHPOffice/PHPPresentation
 */

namespace PhpOffice\PhpPresentation\Tests\Shape\Drawing;

use PhpOffice\PhpPresentation\Shape\Drawing\Base64;

/**
 * Test class for Drawing element
 *
 * @coversDefaultClass PhpOffice\PhpPresentation\Shape\Drawing
 */
class Base64Test extends \PHPUnit_Framework_TestCase
{
    public function setUp()
    {
        parent::setUp();

        DrawingTest::$getimagesizefromstringExists = true;
    }

    protected $imageData = 'data:image/jpeg;base64,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';

    public function testData()
    {
        $oDrawing = new Base64();

        $this->assertNull($oDrawing->getData());
        $oDrawing->setData($this->imageData);
        $this->assertNotEmpty($oDrawing->getData());
    }

    public function testExtension()
    {
        $oDrawing = new Base64();
        $oDrawing->setData($this->imageData);
        $this->assertEquals('jpg', $oDrawing->getExtension());
    }

    /**
     * @expectedException \Exception
     * @expectedExceptionMessage Type Mime not found : "fake/fake"
     */
    public function testExtensionException()
    {
        $imgData = str_replace('image/jpeg', 'fake/fake', $this->imageData);

        $oDrawing = new Base64();
        $oDrawing->setData($imgData);
        $oDrawing->getExtension();
    }

    /**
     * @requires PHP 5.4
     */
    public function testMimeType()
    {
        $oDrawing = new Base64();
        $oDrawing->setData($this->imageData);
        $this->assertEquals('image/jpeg', $oDrawing->getMimeType());
    }

    /**
     * @requires PHP 5.4
     */
    public function testMimeTypeFunctionNotExists()
    {
        DrawingTest::$getimagesizefromstringExists = false;
        $oDrawing = new Base64();
        $oDrawing->setData($this->imageData);
        $this->assertEquals('image/jpeg', $oDrawing->getMimeType());
    }
}
